# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 1
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR1_strategy.txt
# LLM Suggested Fallback: C

def friendly_neighbor(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:  # First round
        return "C"
    if len(my_history) == 9:  # Last round
        return "D"
    if "always D" in opponent_program_code.lower() or "return 'D'" in opponent_program_code:
        return "D"
    if "always C" in opponent_program_code.lower() or "return 'C'" in opponent_program_code:
        return "D"  # Exploit always-cooperate
    if len(opp_history) >= 2 and opp_history[-1] == "C" and opp_history[-2] == "D":
        return "C"  # Forgiveness
    return opp_history[-1] if opp_history else "C"